package pl.gda.pg.concurrency.executors;

import static java.lang.System.out;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import static java.lang.Thread.sleep;

public class MyExecutors {
    
    class Task implements Runnable {

        String id;
        ThreadPoolExecutor executor;

        public Task(int id){
            this.id = "" + id;
        }
        public Task(int id, ThreadPoolExecutor executor){
            this.id = "" + id;
            this.executor = executor;
        }
        public Task(String id) {
            this.id = id;
        }
        public Task(String id, ThreadPoolExecutor executor) {
            this(id);
            this.executor = executor;
        }

        @Override
        public void run() {
            for (int i = 0; i < 2; i++) {
                out.println(String.format("My id %s, loop no %d", id, i));
                if (executor != null) {
                    out.println("Pool size: " + executor.getPoolSize());
                    out.println("Finished: " + executor.getCompletedTaskCount());
                }
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class Call implements Callable<Integer> {

        public Integer call() throws Exception {
            sleep(3000);
            return 12345;
//            throw new RuntimeException("Exception from Call"); //what if an exception is thrown?
        }

    }

    public void testScheduleExecutor() throws InterruptedException {
        Task task1 = new Task("1");
        ScheduledExecutorService scheduledThread = Executors.newSingleThreadScheduledExecutor();
        scheduledThread.schedule(task1, 1, TimeUnit.SECONDS);
        scheduledThread.scheduleAtFixedRate(task1, 5, 1, TimeUnit.SECONDS);
        sleep(10000);
        scheduledThread.shutdown();
        scheduledThread.awaitTermination(1, TimeUnit.HOURS);
    }

    public void testOtherExecutors() throws InterruptedException {
        ExecutorService fixedExecutor = Executors.newFixedThreadPool(3);
        for(int i=0; i<5; i++)
            fixedExecutor.execute(new Task(i));

        fixedExecutor.shutdown();
        fixedExecutor.awaitTermination(1, TimeUnit.HOURS);
        System.out.println("-----------------------");

        ExecutorService singleThread = Executors.newSingleThreadExecutor();
        for(int i=0; i<5; i++)
            singleThread.execute(new Task(i));

        singleThread.shutdown();
        singleThread.awaitTermination(1, TimeUnit.HOURS);
    }

    public void testThreadPool() throws InterruptedException {
        ThreadPoolExecutor pooledExecutor = (ThreadPoolExecutor) Executors.newCachedThreadPool();
        for (int i = 0; i < 5; i++) {
            pooledExecutor.execute(new Task(i, pooledExecutor));
            Thread.sleep(200);
        }

        pooledExecutor.shutdown();
        pooledExecutor.awaitTermination(1, TimeUnit.HOURS);
    }

    public void testCallableCall() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        Call myCallable = new Call();

        Future<Integer> future = executor.submit(myCallable);
        out.println("Is future done: " + future.isDone());

        int result = future.get();
        out.println("Callable result: " + result);
        out.println("Is future done: " + future.isDone());

        executor.shutdown();
        executor.awaitTermination(1, TimeUnit.HOURS);
    }
}
